<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/Slider.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $slider = new Slider($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $slider = new Slider($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $slider->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $slider->setTipoTransizione(filter_input(INPUT_POST,"tipoTransizione",FILTER_SANITIZE_STRING));
            $slider->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $slider->setAltezza(filter_input(INPUT_POST,"altezza",FILTER_SANITIZE_STRING));
            $slider->setMostraFreccette(filter_input(INPUT_POST,"mostraFreccette",FILTER_SANITIZE_STRING));
            $slider->setMostraPuntiNavigazione(filter_input(INPUT_POST,"mostraPuntiNavigazione",FILTER_SANITIZE_STRING));
            $slider->setAutoplay(filter_input(INPUT_POST,"autoplay",FILTER_SANITIZE_STRING));
            $slider->setPausaOnHover(filter_input(INPUT_POST,"pausaOnHover",FILTER_SANITIZE_STRING));
            $slider->setTempoPermanenzaSingolaSlide(filter_input(INPUT_POST,"tempoPermanenzaSingolaSlide",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuLargeDesktop(filter_input(INPUT_POST,"slideMostrateSuLargeDesktop",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuDesktop(filter_input(INPUT_POST,"slideMostrateSuDesktop",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuTablet(filter_input(INPUT_POST,"slideMostrateSuTablet",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuSmartphone(filter_input(INPUT_POST,"slideMostrateSuSmartphone",FILTER_SANITIZE_NUMBER_INT));
            $slider->crea();
            header("Location: ../creaSlider.php?id={$slider->getId()}&status=200");
            break;
        case 'modifica':
            $slider->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $slider->setTipoTransizione(filter_input(INPUT_POST,"tipoTransizione",FILTER_SANITIZE_STRING));
            $slider->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $slider->setAltezza(filter_input(INPUT_POST,"altezza",FILTER_SANITIZE_STRING));
            $slider->setMostraFreccette(filter_input(INPUT_POST,"mostraFreccette",FILTER_SANITIZE_STRING));
            $slider->setMostraPuntiNavigazione(filter_input(INPUT_POST,"mostraPuntiNavigazione",FILTER_SANITIZE_STRING));
            $slider->setAutoplay(filter_input(INPUT_POST,"autoplay",FILTER_SANITIZE_STRING));
            $slider->setPausaOnHover(filter_input(INPUT_POST,"pausaOnHover",FILTER_SANITIZE_STRING));
            $slider->setTempoPermanenzaSingolaSlide(filter_input(INPUT_POST,"tempoPermanenzaSingolaSlide",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuLargeDesktop(filter_input(INPUT_POST,"slideMostrateSuLargeDesktop",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuDesktop(filter_input(INPUT_POST,"slideMostrateSuDesktop",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuTablet(filter_input(INPUT_POST,"slideMostrateSuTablet",FILTER_SANITIZE_NUMBER_INT));
            $slider->setSlideMostrateSuSmartphone(filter_input(INPUT_POST,"slideMostrateSuSmartphone",FILTER_SANITIZE_NUMBER_INT));
            $slider->modifica();
            header("Location: ../creaSlider.php?id={$slider->getId()}&status=250");
            break;
        case 'elimina':
            $slider->elimina();
            echo "ok";
            break;
        case 'duplica':
            $slider->caricaDatiDalDatabase();
            $idNuovaForm = $slider->duplica();
            header("Location: ../creaSlider.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $slider->duplicaElemento(filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'stampaElementi':
            $slider->stampaElementi();
            break;
        case 'creaElemento':
            $nome = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $link = filter_input(INPUT_POST, "link",FILTER_SANITIZE_STRING);
            $slider->creaElemento($nome,$link);
            echo "ok";
            break;
        case 'spostaElemento':
            $slider->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome       = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
            $link       = filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING);
            $testo      = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $tipo       = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING);
            $overlay    = filter_input(INPUT_POST,"overlay",FILTER_SANITIZE_STRING);
            $gradiente  = filter_input(INPUT_POST,"gradiente",FILTER_SANITIZE_STRING);
            $linkPulsante   = filter_input(INPUT_POST,"linkPulsante",FILTER_SANITIZE_STRING);
            $stilePulsante  = filter_input(INPUT_POST,"stilePulsante",FILTER_SANITIZE_STRING);
            $titoloPulsante = filter_input(INPUT_POST,"titoloPulsante",FILTER_SANITIZE_STRING);
            
            $slider->modificaElemento($idElemento,$nome, $link, $testo,$tipo,$overlay,$gradiente,$linkPulsante,$stilePulsante,$titoloPulsante);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'modificaFileMultimedialeElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif","video/mp4");
            $estensioneFile  = mime_content_type($_FILES["file"]["tmp_name"]);
            $cartellaDestinazione = ($estensioneFile=="video/mp4") ? "../../../../file/video" : "../../../../immagini/slider";
            
            $gestoreUpload   = new GestoreUpload("file", $tipiFileAmmessi, 8,$cartellaDestinazione, 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1 && $estensioneFile!="video/mp4") {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFileMultimediale = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }

                if($impostazioni["generaThumbnail"]=="si") {
                    $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                    $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
                }
            }
            else if($esitoUpload["fileElaborati"]==1 && $estensioneFile=="video/mp4") {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFileMultimediale = str_replace("../","",$esitoUpload["percorso"]);
                }
            }
            else {
                $percorsoFileMultimediale = "";
            }
            $slider->cambiaFileMultimedialeElemento($idElemento,$percorsoFileMultimediale);

            
            echo "../../../$percorsoFileMultimediale";
            break;
        case 'eliminaFileMultimedialeElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $slider->cambiaFileMultimedialeElemento($idElemento,'immagini/altro/segnaposto.png');
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $slider->cambiaFileMultimedialeElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaElemento':
            $slider->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
